# docker-monitoring-sidecar

This repository contains the files needed to deploy a lightweight Docker monitoring sidecar stack:

- **dockerproxy** (docker-socket-proxy)
- **cadvisor**
- **docker_exporter** (docker_state_exporter)

## What gets deployed?

1. **dockerproxy**
  - Image: `ghcr.io/tecnativa/docker-socket-proxy:latest`
  - Internal/Host port: `2375` (bound to `LOCAL_IP`)
  - Config: `.proxy-docker.env`

2. **cadvisor**
  - Image: `gcr.io/cadvisor/cadvisor:v0.47.2`
  - Internal port: 8080
  - Host port: `8081` (bound to `LOCAL_IP`)

3. **docker_exporter**
  - Image: `karugaru/docker_state_exporter`
  - Internal port: 8080
  - Host port: `8082` (bound to `LOCAL_IP`)
  - Docker access: via `dockerproxy` (no direct `/var/run/docker.sock` mount)

## Requirements

- Docker ≥ 20.10
- Docker Compose (v2 plugin recommended)
- Open firewall ports if required (depending on your network policy):
  - `LOCAL_IP:2375/tcp` (dockerproxy) **keep private / protected**
  - `LOCAL_IP:8081/tcp` (cadvisor)
  - `LOCAL_IP:8082/tcp` (docker_exporter)

## Configuration

Create/update these files:

- `.local.env` (per server)
  - `LOCAL_IP=<host_ip>`

- `.proxy-docker.env` (per server if needed)  (Don't upload it to the repo; use ` .proxy-docker.env.dist`)
  - Enable/disable Docker API endpoints (0/1)

## Startup instructions

1. Clone this repository
  ```bash
  git clone <GIT_URL>
  cd <REPO_FOLDER>
  ```

## Makefile use

Environment file per server: `\.local.env` (Don't upload it to the repo; use ` .local.env.dist`)

Useful Commands:

- Start background services:
  ```shell
  make up
  ```
- Stop and delete:
  ```shell
  make down
  ```
- Restart:
  ```shell
  make restart
  ```
- View container status:
  ```shell
  make ps
  ```
- View container status:
  ```shell
  make logs
  ```
- Enter containers (shell):
  ```shell
  make proxy      # Enter in `dockerproxy`
  make cadvisor   # Enter in `cadvisor`
  make exporter   # Enter in `docker_exporter`
  ```

## Security notes and quick tests:
- Ensure `LOCAL_IP` is configured in `.local.env`.
  ```shell
  hostname -I
  grep '^LOCAL_IP=' .local.env | cut -d= -f2
  ```
- Test endpoints:
  ```shell
  export LOCAL_IP=$(grep '^LOCAL_IP=' .local.env | cut -d= -f2)
  curl -sS http://$LOCAL_IP:8081/ | head -n 30 # cAdvisor UI
  curl -sS http://$LOCAL_IP:8081/metrics | head -n 30 # cAdvisor Metrics
  curl -sS http://$LOCAL_IP:8082/metrics | head -n 30 # docker_exporter Metrics
  ```

- Ensure `LOCAL_IP:2375` is a private IP address and the port is not accessible from the outside.
